﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Diagnostics" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business.App" %>
<%@ Import Namespace="Soneta.Business.Db" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Core.GIODO" %>
<%@ Import Namespace="Soneta.Core.UI.GIODO" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Rejestr kategorii czynności przetwarzania</title>
    <meta content="C#" name="CODE_LANGUAGE">
    <meta content="JavaScript" name="vs_defaultClientScript">
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">

    <script runat="server">

        private String PodmiotPrzetwarzajacy
        {
            get
            {
                IPieczątkaFirmy pieczątka = ReportHeader.GetPieczątka( dc, null, false);
                return pieczątka.NazwaFormatowana + Environment.NewLine + pieczątka.Adres.Linia1 + Environment.NewLine + pieczątka.Adres.Linia2;
            }
        }


        private String InspektorDanychOsobowych
        {
            get
            {
                return CoreModule.GetInstance(dc).Config.GIODO.ABI.Imię + " " + CoreModule.GetInstance(dc).Config.GIODO.ABI.Nazwisko + Environment.NewLine + CoreModule.GetInstance(dc).Config.GIODO.ABI.DaneKontaktowe;
            }
        }

        void OnContextLoad(Object sender, EventArgs args)
        {
            DataLabelPrzetwarzajacy.EditValue = PodmiotPrzetwarzajacy;
            DataLabelInspektor.EditValue = InspektorDanychOsobowych;
            var title = "Rejestr kategorii czynności przetwarzania|";
            GIODOPrzetwarzaniaViewInfoParams param = null;
                if(dc.Context.Get<GIODOPrzetwarzaniaViewInfoParams>(out param)) {
                var titleDesc = "";
                if(param.ZbiorDanych != null)
                    titleDesc += "</STRONG>Zbiór danych:<STRONG> " + param.ZbiorDanych + ", ";
                if(param.KategoriaOsob != null)
                    titleDesc += "</STRONG>Kategoria osób:<STRONG> " + param.KategoriaOsob + ", ";
                if(param.KategoriaDanychOsobowych != null && param.KategoriaDanychOsobowych.Length > 0) {
                    var kategDO = "";
                    foreach(GIODOKategoriaDanychOsobowych gko in param.KategoriaDanychOsobowych)
                        kategDO += gko.Nazwa + ", ";
                    titleDesc += "</STRONG>Kategoria danych osobowych:<STRONG> " + kategDO.Trim(' ').Trim(',') + ", ";
                }
                if(param.KategoriaOdbiorcow != null && param.KategoriaOdbiorcow.Length > 0) {
                    var kategO = "";
                    foreach(GIODOKategoriaOdbiorcow gko in param.KategoriaOdbiorcow)
                        kategO += gko.Nazwa + ", ";
                    titleDesc += "</STRONG>Kategoria danych osobowych:<STRONG> " + kategO.Trim(' ').Trim(',') + ", ";
                }
                if(param.Cel != null)
                    titleDesc += "</STRONG>Cel przetwarzania:<STRONG> " + param.Cel + ", ";
                title += titleDesc.Trim(' ').Trim(',');
                
            } 
            ReportHeader.Title = title;
        }


    </script>

</head>
<body>
    <form method="post" runat="server">
        <ea:datacontext id="dc" landscape="True" runat="server" oncontextload="OnContextLoad"></ea:datacontext>
        <eb:ReportHeader id="ReportHeader" runat="server" title="Rejestr kategorii czynności przetwarzania"></eb:ReportHeader>
        <table id="Table1" cellspacing="0" cellpadding="1" width="100%" border="0">
            <colgroup width="20%">
            </colgroup>
            <colgroup width="30%">
            </colgroup>
            <colgroup width="20%">
            </colgroup>
            <colgroup width="30%">
            </colgroup>
            <tr>
                <td><font face="Tahoma" size="2">Podmiot przetwarzający:</font></td>
                <td>
                    <ea:datalabel id="DataLabelPrzetwarzajacy" runat="server" encodehtml="true"></ea:datalabel>
                </td>

                <td><font face="Tahoma" size="2">Inspektor ochrony danych:</font></td>
                <td>
                    <ea:datalabel id="DataLabelInspektor" runat="server" encodehtml="true"></ea:datalabel>
                </td>
            </tr>
        </table>

        <ea:grid id="Grid" runat="server" rowsinrow="1" rowtypename="Soneta.Core.GIODO.GIODOPrzetwarzanie,Soneta.Core">
                <Columns>
                    <ea:GridColumn Width="4" Align="Center" DataMember="#" Caption="LP." Width="5"></ea:GridColumn>
                    <ea:GridColumn runat="server" Align="Center" DataMember="Numer" EncodeHTML="true" Caption="Numer" Width="13"></ea:GridColumn>
                    <ea:GridColumn runat="server" Align="Left" DataMember="ZbiorDanych.AdministratorDanychOsobowych" EncodeHTML="true" Caption="Administrator danych osobowych"></ea:GridColumn>
                    <ea:GridColumn runat="server" Align="Left" DataMember="ZbiorDanych.Nazwa" EncodeHTML="true" Caption="Zbiór danych" Width="25"></ea:GridColumn>
                    <ea:GridColumn runat="server" Align="Left" DataMember="Nazwa" EncodeHTML="true" Caption="Kategorie przetwarzań" Width="25"></ea:GridColumn>
                    <ea:GridColumn runat="server" Align="Left" DataMember="ZbiorDanych.Panstwa" EncodeHTML="true" Caption="Przekazanie danych do państw trzecich" Width="20"></ea:GridColumn>
                    <ea:GridColumn runat="server" Align="Left" DataMember="ZbiorDanych.OpisSrodkowBezp" EncodeHTML="true" Caption="Opis środków bezpieczeństwa"></ea:GridColumn>

                </Columns>
            </ea:grid>
        <eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
    </form>
</body>
</html>
